<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ShowFormTellFriend()
  ===================================================*/

  function ShowFormTellFriend() {

    // vars global configuration
    global $dbConn, $theme_path;

    // vars url & form
    global $id, $fav;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $my_name, $my_email, $friend_name, $friend_email;

    $tpl = new Template();

    $links_obj = new clsLink;
    $links_obj->query               = "select * from idx_link where link_id = '$id'";
    $links_obj->table_name          = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $links_obj->category_separator  = $category_separator;
    $links_obj->max_rows            = 1;

    if (!empty($id) && empty($fav)) {
      global $title, $url;
      $query  = "select * from idx_link where link_id = '$id'";
      $result = $dbConn->Execute($query);
      $title  = $result->Fields("title");
      $url    = $result->Fields("url");

      DisplayTemplate($theme_path . "tell_friend_form.html",
                      "\$favorite,\$fav,\$id,\$error_msg,\$my_name,\$my_email,"
                        . "\$friend_name,\$friend_email,\$title,\$url");
    }
    elseif (!empty($fav) && !empty($id)) {
      global $favorite;
      $query    = "select title from idx_favorites where favorite_id = '$id'";
      $result   = $dbConn->Execute($query);
      $favorite = $result->Fields("title");

      DisplayTemplate($theme_path . "tell_friend_fav_form.html",
                      "\$favorite,\$fav,\$id,\$error_msg,\$my_name,\$my_email,\$friend_name,\$friend_email");
    }
    else
      DisplayTemplate($theme_path . "tell_friend_site_form.html",
                      "\$fav,\$id,\$error_msg,\$my_name,\$my_email,\$friend_name,\$friend_email");
    }


  /*===================================================
    ProcessFormTellFriend()
  ===================================================*/
  
  function ProcessFormTellFriend() {

    // vars global configuration
    global $theme_path, $email_address;

    // vars url & form
    global $id, $username, $my_name, $my_email, $friend_name, $friend_email;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    $tpl = new Template();

    $my_name      = stripslashes($my_name);
    $my_email     = stripslashes($my_email);
    $friend_name  = stripslashes($friend_name);
    $friend_email = stripslashes($friend_email);

    if (empty($my_name)) {
      $error_msg = $msg["10201"];
    }
    elseif (empty($my_email)) {
      $error_msg = $msg["10202"];
    }
    elseif (!IsEmailAddress($my_email)) {
      $error_msg = $msg["10203"];
    }
    elseif (empty($friend_name)) {
      $error_msg = $msg["10204"];
    }
    elseif (empty($friend_email)) {
      $error_msg = $msg["10205"];
    }
    elseif (!IsEmailAddress($friend_email)) {
      $error_msg = $msg["10203"];
    }

    if (empty($error_msg)) {
      if (empty($id)) {

        // tell friend about website
        $body = EvalTemplate($theme_path . "mail/tell_friend_website.mail", "\$my_name,\$my_email,\$friend_name,\$friend_email");
        $from = $email_address;
        @mail($friend_email, $msg["10213"], $body, "From: $from\nX-Mailer: INDEXU_X-Mailer/1.0");
      }
      else {

        // tell friend about a link
        $links_obj = new clsLink;
        $links_obj->query               = "select * from idx_link where link_id = '$id'";
        $links_obj->table_name          = "idx_link";
        $links_obj->category_table_name = "idx_category";
        $links_obj->category_separator  = $category_separator;
        $links_obj->max_rows            = 1;
        $links_obj->template_file       = $theme_path . "mail/tell_friend_link.mail";
        $body                           = $links_obj->Display();

        $tpl->assign('friend_name', $friend_name);
        $tpl->assign('friend_email', $friend_email);
        $tpl->assign('my_name', $my_name);
        $tpl->assign('my_email', $my_email);
        $body = $tpl->fetch('var:' . $body);

        $from = $email_address;
        @mail($friend_email, $msg["10211"], $body, "From: $from\nX-Mailer: INDEXU_X-Mailer/1.0");
      }

      DisplayTemplate($theme_path . "tell_friend_ok.html",
                      "\$id,\$error_msg,\$my_name,\$my_email,\$friend_name,\$friend_email");
    }
    else
      ShowFormTellFriend();
  }


  /*===================================================
    ProcessFormTellFriendFavorite()
  ===================================================*/
  
  function ProcessFormTellFriendFavorite() {

    // vars global configuration
    global $theme_path, $email_address;

    // vars url & form
    global $id, $username, $my_name, $my_email, $friend_name, $friend_email;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $fav_item;

    $my_name      = stripslashes($my_name);
    $my_email     = stripslashes($my_email);
    $friend_name  = stripslashes($friend_name);
    $friend_email = stripslashes($friend_email);

    if (empty($my_name)) {
      $error_msg = $msg["10201"];
    }
    elseif (empty($my_email)) {
      $error_msg = $msg["10202"];
    }
    elseif (!IsEmailAddress($my_email)) {
      $error_msg = $msg["10203"];
    }
    elseif (empty($friend_name)) {
      $error_msg = $msg["10204"];
    }
    elseif (empty($friend_email)) {
      $error_msg = $msg["10205"];
    }
    elseif (!IsEmailAddress($friend_email)) {
      $error_msg = $msg["10203"];
    }

    if (empty($error_msg)) {
      $links_obj = new clsLink;
      $links_obj->table_name                 = "idx_link";
      $links_obj->favorite_table_name        = "idx_favorites";
      $links_obj->favorite_detail_table_name = "idx_favorites_detail";
      $links_obj->category_table_name        = "idx_category";
      $links_obj->category_separator         = $category_separator;
      $links_obj->template_file              = $theme_path . "mail/tell_friend_favorite_rows.mail";
      $fav_item                              = $links_obj->ViewFavorite($id);

      $body = EvalTemplate($theme_path . "mail/tell_friend_favorite.mail",
                                                            "\$my_name,\$my_email,\$friend_name,\$friend_email,\$fav_item");
      $from = $email_address;
      @mail($friend_email, $msg["10214"], $body, "From: $from\nX-Mailer: INDEXU_X-Mailer/1.0");

      DisplayTemplate($theme_path . "tell_friend_ok.html",
                      "\$id,\$error_msg,\$my_name,\$my_email,\$friend_name,\$friend_email");
    }
    else
      ShowFormTellFriend();
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormTellFriend();
  }
  elseif ($pflag == 'tf' && empty($fav)) {
    ProcessFormTellFriend();
  }
  elseif ($pflag == 'tf' && $fav == 1) {
    ProcessFormTellFriendFavorite();
  }

  RunPostFilter(__FILE__);

?>